#include "LoadFromFileCommand.h"
#include <fstream>
#include <iostream>

#include "SimulationEngineController.h"
#include "EntityManager.h"
#include "../DataTypes/Vector3f.h"
#include "../DataTypes/DataString.h"
#include "../DataTypes/DataSimState.h"
namespace SimulationEngine
{

LoadFromFileCommand::LoadFromFileCommand():ICommand(ConfigurationServer::GetInstance()->GetCommandLoadFromFileKey())
{
}

LoadFromFileCommand::~LoadFromFileCommand()
{
}

list<DataParameter*> LoadFromFileCommand::execute(list <DataParameter *> pars)
{
	list <DataParameter *> ret;
	DataString *datastring = (DataString *)(pars.front());
	ifstream ifs(datastring->GetValue().data());
	if (ifs)
	{
		SimulationEngineController::GetInstance()->ResetSimulation();
		stringstream oss;
		oss<<ifs.rdbuf();
		XMLNode xMainNode=XMLNode::parseString(oss.str().data()); 
		XMLNode worldstatenode = xMainNode.getChildNode("Simulation_State");
		bool initialized=false;
		bool syncmode = false;
		bool flagsync=false;
		bool stepmode=false;
		bool stepflag=false;
		bool broadcastflag=false;
		bool fastmode = false;
		bool autoadjustmode = false;
		float stepsize;
		float lastaverageelapsedstep;
		double lasttime;
		double lastsync;
		double syncwait;
		int itercount;
		int lastaveragestepsperiteration;
		Vector3f gravity;
		float worldhardness;
		float worldbounciness;
		int stepsperiteration;
		if (strcmp(worldstatenode.getChildNode("Initialized").getText(),"true")==0)
			initialized = true;

		if (strcmp(worldstatenode.getChildNode("Sync_Mode").getText(),"true")==0)
			syncmode = true;
		if (strcmp(worldstatenode.getChildNode("Flag_Sync").getText(),"true")==0)
			flagsync = true;
		if (strcmp(worldstatenode.getChildNode("Step_Mode").getText(),"true")==0)
			stepmode = true;
		if (strcmp(worldstatenode.getChildNode("Step_Flag").getText(),"true")==0)
			stepflag = true;
		if (strcmp(worldstatenode.getChildNode("Broadcast_Flag").getText(),"true")==0)
			broadcastflag = true;
		if (strcmp(worldstatenode.getChildNode("Fast_Mode").getText(),"true")==0)
			fastmode = true;
		if (strcmp(worldstatenode.getChildNode("AutoAdjust_Mode").getText(),"true")==0)
			autoadjustmode = true;
		lastaverageelapsedstep = atof(worldstatenode.getChildNode("Last_Average_Elapsed_Steps").getText());
		stepsize = atof(worldstatenode.getChildNode("Step_Size").getText());
		char *endptr;
		lasttime = strtod(worldstatenode.getChildNode("Last_Time").getText(), &endptr);
		lastsync = strtod(worldstatenode.getChildNode("Last_Sync").getText(), &endptr);
		syncwait = strtod(worldstatenode.getChildNode("Sync_Wait").getText(), &endptr);
		itercount = atoi(worldstatenode.getChildNode("Iter_Count").getText());
		lastaveragestepsperiteration= atoi(worldstatenode.getChildNode("Last_Average_Steps_Per_Iteration").getText());
		XMLNode gravitynode = worldstatenode.getChildNode("Gravity");
		gravity.SetFirst(atof(gravitynode.getChildNode("Gravity_X").getText()));
		gravity.SetSecond(atof(gravitynode.getChildNode("Gravity_Y").getText()));
		gravity.SetThird(atof(gravitynode.getChildNode("Gravity_Z").getText()));
		worldhardness = atof(worldstatenode.getChildNode("World_Hardness").getText());
		worldbounciness = atof(worldstatenode.getChildNode("World_Bounciness").getText());
		stepsperiteration = atoi(worldstatenode.getChildNode("Steps_Per_Iteration").getText());
		DataSimState simstate(initialized,syncmode, flagsync,stepmode, stepflag,broadcastflag,stepsize,lasttime,lastsync,syncwait,itercount,gravity,worldhardness,worldbounciness,stepsperiteration, fastmode, autoadjustmode, lastaverageelapsedstep, lastaveragestepsperiteration);
		SimulationEngineController::GetInstance()->SetState(simstate);
		XMLNode entitiesnode=xMainNode.getChildNode("Entities");
		int childnumber=0;
			
		while (!entitiesnode.getChildNode(childnumber).isEmpty())
		{
			XMLNode nodeentity =entitiesnode.getChildNode(childnumber);
			DataEntity *dataentity = this->LoadEntity(nodeentity);
			ISimEntity *entity=0;
			if (DataRobot *datarobot = dynamic_cast<DataRobot *>(dataentity))
			{
				entity = new SimRobot(*datarobot);
			}	
			else if (DataBall *databall = dynamic_cast<DataBall *>(dataentity))
			{
				entity = new SimBall(*databall);
			}
			else if (DataField *datafield = dynamic_cast<DataField *>(dataentity))
			{
				entity = new SimField(*datafield);
			}
			EntityManager *entitymanager = EntityManager::GetInstance();
			entitymanager->AddEntity(entity);
			childnumber++;
		}
		xMainNode.deleteNodeContent();
		ret.push_back(new DataString("Simulation loaded successfully"));
	}
	else
		ret.push_back(new DataString("Simulation could not be loaded"));
	

	return ret;
}

DataEntity *LoadFromFileCommand::LoadEntity(XMLNode entitynode)
{
	if (strcmp(entitynode.getAttribute("Type"),"Robot")==0)
	{
		return DecodeRobot(entitynode);
	}
	else if (strcmp(entitynode.getAttribute("Type"),"Field")==0)
	{
		return DecodeField(entitynode);
	}
	else if (strcmp(entitynode.getAttribute("Type"),"Ball")==0)
	{
		return DecodeBall(entitynode);
	}
	return new DataEntity();
}

DataRobot *LoadFromFileCommand::DecodeRobot(XMLNode robotnode)
{
	XMLNode entityidnode = robotnode.getChildNode("Entity_id");
	int entityid = atoi(entityidnode.getText());
	XMLNode bodiesnode = robotnode.getChildNode("Bodies");
	int bodynumber = 0;
	list<DataObject *> objects;
	while (!bodiesnode.getChildNode(bodynumber).isEmpty())
	{
		XMLNode currentbody = bodiesnode.getChildNode(bodynumber);
		DataObject *object=0;
		if (strcmp(currentbody.getName(), "Body")==0)
		{
			XMLNode bodyidnode = currentbody.getChildNode("Body_id");
			int bodyid = atoi(bodyidnode.getText());
			int bodymaterial;
			XMLNode bodymaterialnode = currentbody.getChildNode("Material");
			bodymaterial = atoi(bodymaterialnode.getText());
			
			float bodymass;
			XMLNode bodymassnode = currentbody.getChildNode("Mass");
			bodymass = atof(bodymassnode.getText());
			
			Vector3f position;
			XMLNode position_x_node = currentbody.getChildNode("Position_X");
			position.SetFirst(atof(position_x_node.getText()));
			XMLNode position_y_node = currentbody.getChildNode("Position_Y");
			position.SetSecond(atof(position_y_node.getText()));
			XMLNode position_z_node = currentbody.getChildNode("Position_Z");
			position.SetThird(atof(position_z_node.getText()));
			
			Vector3f rotation;
			XMLNode rotation_x_node = currentbody.getChildNode("Rotation_X");
			rotation.SetFirst(atof(rotation_x_node.getText()));
			XMLNode rotation_y_node = currentbody.getChildNode("Rotation_Y");
			rotation.SetSecond(atof(rotation_y_node.getText()));
			XMLNode rotation_z_node = currentbody.getChildNode("Rotation_Z");
			rotation.SetThird(atof(rotation_z_node.getText()));
			
			Vector3f linearvelocity;
			XMLNode linearvel_x_node = currentbody.getChildNode("Linear_Velocity_X");
			linearvelocity.SetFirst(atof(linearvel_x_node.getText()));
			XMLNode linearvel_y_node = currentbody.getChildNode("Linear_Velocity_Y");
			linearvelocity.SetSecond(atof(linearvel_y_node.getText()));
			XMLNode linearvel_z_node = currentbody.getChildNode("Linear_Velocity_Z");
			linearvelocity.SetThird(atof(linearvel_z_node.getText()));
			
			Vector3f angularvelocity;
			XMLNode angularvel_x_node = currentbody.getChildNode("Angular_Velocity_X");
			angularvelocity.SetFirst(atof(angularvel_x_node.getText()));
			XMLNode angularvel_y_node = currentbody.getChildNode("Angular_Velocity_Y");
			angularvelocity.SetSecond(atof(angularvel_y_node.getText()));
			XMLNode angularvel_z_node = currentbody.getChildNode("Angular_Velocity_Z");
			angularvelocity.SetThird(atof(angularvel_z_node.getText()));
			
			if (strcmp(currentbody.getAttribute("Type"), "Box")==0)
			{				
				Vector3f size;
				XMLNode size_x_node = currentbody.getChildNode("Size_X");
				size.SetFirst(atof(size_x_node.getText()));
				XMLNode size_y_node = currentbody.getChildNode("Size_Y");
				size.SetSecond(atof(size_y_node.getText()));
				XMLNode size_z_node = currentbody.getChildNode("Size_Z");
				size.SetThird(atof(size_z_node.getText()));
				object = new DataBox(bodyid, size, position, rotation, bodymaterial, bodymass, linearvelocity, angularvelocity);
			}
			else if (strcmp(currentbody.getAttribute("Type"), "Sphere")==0)
			{
				XMLNode radiusnode = currentbody.getChildNode("Radius");
				float radius = atof(radiusnode.getText());
				object = new DataSphere(bodyid, radius, position, rotation, bodymaterial, bodymass, linearvelocity, angularvelocity);
			}
			else if (strcmp(currentbody.getAttribute("Type"), "WheelCylinder")==0)
			{
				XMLNode radiusnode = currentbody.getChildNode("Radius");
				float radius = atof(radiusnode.getText());
				XMLNode lengthnode = currentbody.getChildNode("Length");
				float length = atof(lengthnode.getText());
				object = new DataWheelCylinder(bodyid, radius, length, position, rotation, bodymaterial, bodymass, linearvelocity, angularvelocity);
			}
			else if (strcmp(currentbody.getAttribute("Type"), "Cylinder")==0)
			{
				XMLNode radiusnode = currentbody.getChildNode("Radius");
				float radius = atof(radiusnode.getText());
				XMLNode lengthnode = currentbody.getChildNode("Length");
				float length = atof(lengthnode.getText());
				object = new DataCylinder(bodyid, radius, length, position, rotation, bodymaterial, bodymass, linearvelocity, angularvelocity);
			}
		}		
		objects.push_back(object);
		bodynumber++;
	}
	
	XMLNode jointsnode = robotnode.getChildNode("Joints");
	int jointnumber = 0;
	while (!jointsnode.getChildNode(jointnumber).isEmpty())
	{
		DataObject *object=0;
		XMLNode currentjoint = jointsnode.getChildNode(jointnumber);
		if (strcmp(currentjoint.getName(), "Joint")==0)
		{
			XMLNode jointidnode = currentjoint.getChildNode("Joint_id");
			int jointid = atoi(jointidnode.getText());
			XMLNode body1node = currentjoint.getChildNode("Body_1");
			int body1 = atoi(body1node.getText());
			XMLNode body2node = currentjoint.getChildNode("Body_2");
			int body2 = atoi(body2node.getText());
			if (strcmp(currentjoint.getAttribute("Type"), "WheelJoint")==0)
			{				
				Vector3f axis1;
				XMLNode axis1_x_node = currentjoint.getChildNode("Axis_1_X");
				axis1.SetFirst(atof(axis1_x_node.getText()));
				XMLNode axis1_y_node = currentjoint.getChildNode("Axis_1_Y");
				axis1.SetSecond(atof(axis1_y_node.getText()));
				XMLNode axis1_z_node = currentjoint.getChildNode("Axis_1_Z");
				axis1.SetThird(atof(axis1_z_node.getText()));
				Vector3f axis2;
				XMLNode axis2_x_node = currentjoint.getChildNode("Axis_2_X");
				axis2.SetFirst(atof(axis2_x_node.getText()));
				XMLNode axis2_y_node = currentjoint.getChildNode("Axis_2_Y");
				axis2.SetSecond(atof(axis2_y_node.getText()));
				XMLNode axis2_z_node = currentjoint.getChildNode("Axis_2_Z");
				axis2.SetThird(atof(axis2_z_node.getText()));
				XMLNode hardnessnode = currentjoint.getChildNode("Hardness");
				float hardness;
				hardness= atof(hardnessnode.getText());
				XMLNode bouncinessnode = currentjoint.getChildNode("Bounciness");
				float bounciness;
				bounciness= atof(bouncinessnode.getText());
				XMLNode maxtorquenode = currentjoint.getChildNode("Maximum_Torque");
				float maxtorque;
				maxtorque= atof(maxtorquenode.getText());
				XMLNode velocitynode = currentjoint.getChildNode("Velocity");
				float velocity;
				velocity= atof(velocitynode.getText());
				object = new DataWheelJoint(jointid, body1, body2, axis1, axis2, hardness, bounciness, maxtorque, velocity);
				
				
			}
			else if (strcmp(currentjoint.getAttribute("Type"), "FixedJoint")==0)
			{
				object = new DataFixedJoint(jointid, body1, body2);
			}
			objects.push_back(object);
		}
		jointnumber++;
	}
	list<int> motors;
	XMLNode motorsnode = robotnode.getChildNode("Motors"); 
	if (!motorsnode.isEmpty())
	{
		int childnumber = 0;
		while (!motorsnode.getChildNode(childnumber).isEmpty())
		{
			XMLNode currentmotor = motorsnode.getChildNode(childnumber);
			int motornumber = atoi(currentmotor.getText());
			motors.push_back(motornumber);
			childnumber++;
		}
	}
	
	XMLNode refbodynode = robotnode.getChildNode("Reference_Body");
	int refbody = atoi(refbodynode.getText());
	return new DataRobot(entityid, objects, motors, refbody);
}

DataField *LoadFromFileCommand::DecodeField(XMLNode fieldnode)
{

	XMLNode entityidnode = fieldnode.getChildNode("Entity_id");
	int entityid = atoi(entityidnode.getText());
	
	XMLNode bodiesnode = fieldnode.getChildNode("Bodies");
	int childnumber=0;
	
	list<DataBody *> objects;
	while (!bodiesnode.getChildNode(childnumber).isEmpty())
	{
		XMLNode currentbody = bodiesnode.getChildNode(childnumber);
		DataBody *object=0;
		if (strcmp(currentbody.getName(), "Body")==0)
		{
			XMLNode bodyidnode = currentbody.getChildNode("Body_id");
			int bodyid = atoi(bodyidnode.getText());
			int bodymaterial;
			XMLNode bodymaterialnode = currentbody.getChildNode("Material");
			bodymaterial = atoi(bodymaterialnode.getText());
			
			float bodymass;
			XMLNode bodymassnode = currentbody.getChildNode("Mass");
			bodymass = atof(bodymassnode.getText());
			
			Vector3f position;
			XMLNode position_x_node = currentbody.getChildNode("Position_X");
			position.SetFirst(atof(position_x_node.getText()));
			XMLNode position_y_node = currentbody.getChildNode("Position_Y");
			position.SetSecond(atof(position_y_node.getText()));
			XMLNode position_z_node = currentbody.getChildNode("Position_Z");
			position.SetThird(atof(position_z_node.getText()));
			
			Vector3f rotation;
			XMLNode rotation_x_node = currentbody.getChildNode("Rotation_X");
			rotation.SetFirst(atof(rotation_x_node.getText()));
			XMLNode rotation_y_node = currentbody.getChildNode("Rotation_Y");
			rotation.SetSecond(atof(rotation_y_node.getText()));
			XMLNode rotation_z_node = currentbody.getChildNode("Rotation_Z");
			rotation.SetThird(atof(rotation_z_node.getText()));
			
			if (strcmp(currentbody.getAttribute("Type"), "Box")==0)
			{
				Vector3f size;
				XMLNode size_x_node = currentbody.getChildNode("Size_X");
				size.SetFirst(atof(size_x_node.getText()));
				XMLNode size_y_node = currentbody.getChildNode("Size_Y");
				size.SetSecond(atof(size_y_node.getText()));
				XMLNode size_z_node = currentbody.getChildNode("Size_Z");
				size.SetThird(atof(size_z_node.getText()));
				object = new DataBox(bodyid, size, position, rotation, bodymaterial, bodymass, Vector3f(0,0,0),Vector3f(0,0,0));
			}
			else if (strcmp(currentbody.getAttribute("Type"), "Sphere")==0)
			{
				XMLNode radiusnode = currentbody.getChildNode("Radius");
				float radius = atof(radiusnode.getText());
				object = new DataSphere(bodyid, radius, position, rotation, bodymaterial, bodymass, Vector3f(0,0,0),Vector3f(0,0,0));
			}
			else if (strcmp(currentbody.getAttribute("Type"), "WheelCylinder")==0)
			{
				XMLNode radiusnode = currentbody.getChildNode("Radius");
				float radius = atof(radiusnode.getText());
				XMLNode lengthnode = currentbody.getChildNode("Length");
				float length = atof(lengthnode.getText());
				object = new DataWheelCylinder(bodyid, radius, length, position, rotation, bodymaterial, bodymass, Vector3f(0,0,0),Vector3f(0,0,0));
			}
			else if (strcmp(currentbody.getAttribute("Type"), "Cylinder")==0)
			{
				XMLNode radiusnode = currentbody.getChildNode("Radius");
				float radius = atof(radiusnode.getText());
				XMLNode lengthnode = currentbody.getChildNode("Length");
				float length = atof(lengthnode.getText());
				object = new DataCylinder(bodyid, radius, length, position, rotation, bodymaterial, bodymass, Vector3f(0,0,0),Vector3f(0,0,0));
			}
		}		
		objects.push_back(object);
		childnumber++;
	}
	
	return new DataField(entityid, objects);
}

DataBall *LoadFromFileCommand::DecodeBall(XMLNode ballnode)
{
	XMLNode entityidnode = ballnode.getChildNode("Entity_id");
	int entityid = atoi(entityidnode.getText());
	int bodymaterial;
	XMLNode bodymaterialnode = ballnode.getChildNode("Material");
	bodymaterial = atoi(bodymaterialnode.getText());
	
	float bodymass;
	XMLNode bodymassnode = ballnode.getChildNode("Mass");
	bodymass = atof(bodymassnode.getText());
	Vector3f position;
	XMLNode position_x_node = ballnode.getChildNode("Position_X");
	position.SetFirst(atof(position_x_node.getText()));
	XMLNode position_y_node = ballnode.getChildNode("Position_Y");
	position.SetSecond(atof(position_y_node.getText()));
	XMLNode position_z_node = ballnode.getChildNode("Position_Z");
	position.SetThird(atof(position_z_node.getText()));
	
	Vector3f rotation;
	XMLNode rotation_x_node = ballnode.getChildNode("Rotation_X");
	rotation.SetFirst(atof(rotation_x_node.getText()));
	XMLNode rotation_y_node = ballnode.getChildNode("Rotation_Y");
	rotation.SetSecond(atof(rotation_y_node.getText()));
	XMLNode rotation_z_node = ballnode.getChildNode("Rotation_Z");
	rotation.SetThird(atof(rotation_z_node.getText()));
	XMLNode radiusnode = ballnode.getChildNode("Radius");
	float radius = atof(radiusnode.getText());
	
	
	Vector3f linearvelocity;
	XMLNode linearvel_x_node = ballnode.getChildNode("Linear_Velocity_X");
	linearvelocity.SetFirst(atof(linearvel_x_node.getText()));
	XMLNode linearvel_y_node = ballnode.getChildNode("Linear_Velocity_Y");
	linearvelocity.SetSecond(atof(linearvel_y_node.getText()));
	XMLNode linearvel_z_node = ballnode.getChildNode("Linear_Velocity_Z");
	linearvelocity.SetThird(atof(linearvel_z_node.getText()));
	
	Vector3f angularvelocity;
	XMLNode angularvel_x_node = ballnode.getChildNode("Angular_Velocity_X");
	angularvelocity.SetFirst(atof(angularvel_x_node.getText()));
	XMLNode angularvel_y_node = ballnode.getChildNode("Angular_Velocity_Y");
	angularvelocity.SetSecond(atof(angularvel_y_node.getText()));
	XMLNode angularvel_z_node = ballnode.getChildNode("Angular_Velocity_Z");
	angularvelocity.SetThird(atof(angularvel_z_node.getText()));
	
	return new DataBall(entityid, bodymaterial, bodymass, position, radius, rotation, linearvelocity, angularvelocity);
}

}
